/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xanalyze.h 
 *       Prototypes for Analyzer functions
 * -----------------------------------------------------------------*/


#ifndef XANALYZE_H_INCLUDED                               
#define XANALYZE_H_INCLUDED

#include <xanadef.h>

#ifndef CLI
#define CLI
#endif

#ifdef __cplusplus
extern "C" {
#endif

/********************************************************************
  Analyzer generics *************************************************
 *******************************************************************/

CLI bx_errtype EXPORT BestXAnalyzerGenDefaultSet( /* @agendefset */
  bx_handletype  handle
);

CLI bx_errtype EXPORT BestXAnalyzerGenProg(       /* @agenprog */
  bx_handletype  handle
);

CLI bx_errtype EXPORT BestXAnalyzerGenRead(       /* @agenread */
  bx_handletype  handle
);

CLI bx_errtype EXPORT BestXAnalyzerGenGet(        /* @agenget */
  bx_handletype  handle,
  bx_agentype    prop,                          
  bx_int32       *val                             /* #RETURN "0x%08lx" */
);

CLI bx_errtype EXPORT BestXAnalyzerGenSet(        /* @agenset */
  bx_handletype  handle,
  bx_agentype    prop,                             
  bx_int32       val                               
);

/********************************************************************
  Analyzer programming *********************************************
 *******************************************************************/

CLI bx_errtype EXPORT BestXAnalyzerProgMode(    /* @aprogmode */
  bx_handletype  handle,
  bx_int32 SoftForce
);

CLI bx_errtype EXPORT BestXAnalyzerRunMode(     /* @arunmode */
  bx_handletype  handle,
  bx_int32 SoftForce
);

CLI bx_errtype EXPORT BestXAnalyzerIsInProgMode( /* @aisinprogmode */
  bx_handletype handle,
  bx_int32 *ProgMode          /* #RETURN "%lu" */
);


/********************************************************************
  Analyzer actions **************************************************
 *******************************************************************/

CLI bx_errtype EXPORT BestXAnalyzerRun(             /* @arun */
  bx_handletype handle
);


CLI bx_errtype EXPORT BestXAnalyzerStop(            /* @astop */
  bx_handletype handle
);

#ifdef __cplusplus
}
#endif


#endif






